﻿<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page Language="c#" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Skrócona lista płac</title>
		<script runat="server">

    WyplataEtat wypłata;
    Currency sumGotowka, sumRor, sumBrutto;
    void Grid_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
        wypłata = args.Row as WyplataEtat;
        if (wypłata==null)
            throw new InvalidOperationException("Lista płac skrócona może być drukowana tylko dla wypłat etatowych. "+args.Row);
    
        WyplataEtatWorker worker = new WyplataEtatWorker();
        worker.Wypłata = wypłata;

        Soneta.Place.Wyplata.PITInfoWorker pit = new Soneta.Place.Wyplata.PITInfoWorker();
        pit.Wypłata = wypłata;

        colNadgodziny.EditValue = worker.Nadgodziny50 + worker.Nadgodziny100;
        colDodatkiB.EditValue = worker.Dodatki + worker.NieZUS;    
        colDodatkiN.EditValue = worker.NDodatki + worker.RozlPit;

        sumBrutto += worker.Brutto;
        sumGotowka += wypłata.Gotówka;
        sumRor += wypłata.Inne;
    }

    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }

        //static bool hideOperator = false;
        bool hideOperator = false;
        [Priority(1)]
        [Caption("Ukryj operatora")]
        public bool HideOperator {
            get { return hideOperator; }
            set {
                hideOperator = value;
                OnChanged(EventArgs.Empty);
            }
        }

        //static bool nazwaWNaglowku = false;
        bool nazwaWNaglowku = false;
        [Priority(2)]
        [Caption("Nazwa w nagłówku")]
        public bool NazwaWNaglowku {
            get { return nazwaWNaglowku; }
            set {
                nazwaWNaglowku = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set { srpars = value; }
    }

    private bool JestPPK(ISessionable session, Date data) {
        YearMonth podlegaOd = PlaceModule.GetInstance(session).Config.PracowniczePlanyKapitałowe.Ogólne.PodlegaOd;
        return podlegaOd != YearMonth.Empty ? new FromTo(podlegaOd.FirstDay, Date.MaxValue).Contains(data) : false;
     }

    void dc_ContextLoad(Object sender, EventArgs e) {
        ListaPlac lista = (ListaPlac)dc[typeof(ListaPlac)];
        if (lista.Bufor)
            ReportHeader1["BUFOR"] = "Lista nie została zatwierdzona!|";
        else
            ReportHeader1["BUFOR"] = "";
            
        if (srpars.NazwaWNaglowku)
            ReportHeader1["NAZWA"] = lista.Definicja.Nazwa + "|";
        else
            ReportHeader1["NAZWA"] = "";
            
        if (srpars.HideOperator)
			stOperator.SubtitleType = SubtitleType.Empty;

        if (lista.Definicja.WalutaPlatnosci != null && lista.Definicja.WalutaPlatnosci.Symbol != Currency.SystemSymbol) {
            colWartość.Format = "";
            colROR.Format = "";
            colGotowka.Format = "";
        }

        colPPKBlank.Visible = colPPKN.Visible = colPPKF.Visible = colPPKP.Visible = JestPPK(lista, lista.DataWyplaty);
		if(lista.DataWyplaty <= new Date(2021, 12, 31))
		{
			colZdrowotnaOdliczenie.Visible = true;
			colEmpty.RowSpan = 1;
		}
		else
		{
			colZdrowotnaOdliczenie.Visible = false;
			colEmpty.RowSpan = 2;			
		}
    }

            void Grid_AfterRender(object sender, System.EventArgs e) {
                if (wypłata==null) return;

                cellBrutto.EditValue = sumBrutto;
                cellNetto.EditValue = sumGotowka + sumRor;
            }

          
    		    
		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="form" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" RightMargin="-1" LeftMargin="-1" TypeName="Soneta.Place.ListaPlac, Soneta.KadryPlace"
				BottomMargin="-1" TopMargin="-1" OnContextLoad="dc_ContextLoad"></ea:datacontext>
			<cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Lista płac {0}|%NAZWA%%BUFOR%</strong>Wydział:<strong> {1}|</strong>Za okres:<strong> {2}|</strong>Data wypłaty:<strong> {3}"
				runat="server" DataMember0="Numer" DataMember1="Wydzial" DataMember2="Okres" DataMember3="DataWyplaty"></cc1:reportheader>

            <ea:grid id="Grid" runat="server" DataMember="Wyplaty" AroundBorder="Single" RowsInRow="4"
				RowTypeName="Soneta.Place.WyplataEtat,Soneta.KadryPlace" onbeforerow="Grid_BeforeRow" onafterrender="Grid_AfterRender">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="Numer.Numer" Caption="Lp" RowSpan="4" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="20" DataMember="PracHistoria.Nazwisko" Total="Info" Caption="Nazwisko" Format="&lt;strong&gt;{0}&lt;/strong&gt;" runat="server"></ea:GridColumn>
					<ea:GridColumn DataMember="PracHistoria.Imie" Caption="Imię" runat="server"></ea:GridColumn>
                    <ea:GridColumn Caption=""></ea:GridColumn>
					<ea:GridColumn runat="server"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Workers.WyplataEtat.Zasadnicze" Total="Sum" Caption="Zasadnicze"
						Format="{0:n}" runat="server"></ea:GridColumn>
					<ea:GridColumn Align="Right" Total="Sum" Caption="Nadgodziny" Format="{0:n}" ID="colNadgodziny" runat="server"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Workers.WyplataEtat.Nocne" Total="Sum" Caption="Nocne"
						Format="{0:n}" runat="server"></ea:GridColumn>
                    <ea:GridColumn Caption=""></ea:GridColumn>
					<ea:GridColumn Align="Right" Total="Sum" Caption="Dodatki/B" Format="{0:n}" ID="colDodatkiB" runat="server"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Workers.WyplataEtat.Potrącenia" Total="Sum" Caption="Potrącenia/B"
						Format="{0:n}" runat="server"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Workers.WyplataEtat.Zasiłki" Total="Sum" Caption="Zasiłki/B"
						Format="{0:n}" runat="server"></ea:GridColumn>
                    <ea:GridColumn Caption=""></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Workers.WyplataEtat.Brutto" Total="Sum" Caption="Brutto"
						Format="{0:n}" ID="colBrutto" runat="server"></ea:GridColumn>
                    <ea:GridColumn Width="18" Align="Right" DataMember="Workers.PITInfo.Przychod26" Total="Sum" Caption="P.zw.art.21 u.1 p.148"
						Format="{0:n}" ID="colPzwzPod" runat="server"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Workers.WyplataEtat.SkładkiZUS" Total="Sum" Caption="Skł. ZUS"
						Format="{0:n}" ID="colZusPrac" runat="server"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Workers.WyplataEtat.SkładkiZUSPomn" Total="Sum" Caption="Skł. ZUS PIT"
						Format="{0:n}" ID="colZusPIT" runat="server"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Workers.PITInfo.ZdrowotneDoOdliczenia" Total="Sum" Caption="NFZ odlicz."
						Format="{0:n}" ID="colZdrowotnaOdliczenie" runat="server"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Workers.PITInfo.SkładkaZdrow" Total="Sum" Caption="NFZ"
						Format="{0:n}" runat="server"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Workers.WyplataEtat.Podatek" Total="Sum" Caption="Zal. PIT"
						Format="{0:n}" ID="colZalPIT" runat="server"></ea:GridColumn>
                    <ea:GridColumn Caption="" ID="colEmpty"></ea:GridColumn>
					<ea:GridColumn Align="Right" Total="Sum" Caption="Dodatki/N" Format="{0:n}" ID="colDodatkiN" runat="server"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Workers.WyplataEtat.NPotrącenia" Total="Sum" Caption="Potrącenia/N"
						Format="{0:n}" runat="server"></ea:GridColumn>                   
					<ea:GridColumn Align="Right" DataMember="Workers.WyplataEtat.NZasiłki" Total="Sum" Caption="Zasiłki/N"
						Format="{0:n}" runat="server"></ea:GridColumn>
                    <ea:GridColumn Caption=""></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Workers.PPK.Podstawa" Total="Sum" Caption="PPK/Podst."
                        Format="{0:n}" ID="colPPKN" runat="server"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Workers.PPK.Pracodawcy" Total="Sum" Caption="PPK/Pracod."
						Format="{0:n}" ID="colPPKF" runat="server"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Workers.PPK.Pracownika" Total="Sum" Caption="PPK/Uczest."
                        Format="{0:n}" ID="colPPKP" runat="server"></ea:GridColumn>
                    <ea:GridColumn ID="colPPKBlank" Caption=""></ea:GridColumn>                   
					<ea:GridColumn Align="Right" DataMember="WartoscCy" Total="Sum" Caption="Do wypłaty" Format="{0:n}" ID="colWartość" runat="server"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Got&#243;wka" Total="Sum" Caption="Got&#243;wka"
						Format="{0:n}" ID="colGotowka" runat="server"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Inne" Total="Sum" Caption="ROR" Format="{0:n}" ID="colROR" runat="server"></ea:GridColumn>
                    <ea:GridColumn Caption=""></ea:GridColumn>
					<ea:GridColumn Width="14" Align="Center" Caption="Data|Podpis" Format="......................"
						ID="colPodpis" RowSpan="4" VAlign="Bottom" runat="server"></ea:GridColumn>
				</Columns>
			</ea:grid>
			<cc1:reportfooter id="ReportFooter1" runat="server">
				<Cells>
					<cc1:FooterCell Caption="Opodatkowane (brutto):" Format1="{0:u}," ID="cellBrutto"></cc1:FooterCell>
					<cc1:FooterCell Caption="Do wypłaty (netto):" Format1="{0:u}," ID="cellNetto"></cc1:FooterCell>
				</Cells>
				<Subtitles>
					<cc1:FooterSubtitle Caption="Sprawdzono pod względem merytorycznym" SubtitleType="DataPodpis" Width="50"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Sprawdzono pod względem formalno prawnym" SubtitleType="DataPodpis" Width="50"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle ID="stOperator" SubtitleType="Operator"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="data"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="gł&#243;wny księgowy"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="kierownik jednostki"></cc1:FooterSubtitle>
				</Subtitles>
			</cc1:reportfooter>
		</form>
	</body>
</HTML>
